// ExcelKonwersjaDlg.cpp : implementation file
//

#include "stdafx.h"
#include "ExcelKonwersja.h"
#include "ExcelKonwersjaDlg.h"
#include <shlwapi.h>
#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

// Implementation
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
END_MESSAGE_MAP()


// CExcelKonwersjaDlg dialog




CExcelKonwersjaDlg::CExcelKonwersjaDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CExcelKonwersjaDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CExcelKonwersjaDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EDIT1, Edit1);
	DDX_Control(pDX, IDC_EDIT2, Edit2);
}

BEGIN_MESSAGE_MAP(CExcelKonwersjaDlg, CDialog)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_BUTTON1, &CExcelKonwersjaDlg::OnBnClickedButton1)
	ON_BN_CLICKED(IDC_BUTTON2, &CExcelKonwersjaDlg::OnBnClickedButton2)
	ON_BN_CLICKED(IDC_BUTTON3, &CExcelKonwersjaDlg::OnBnClickedButton3)
END_MESSAGE_MAP()


// CExcelKonwersjaDlg message handlers

BOOL CExcelKonwersjaDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here

	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CExcelKonwersjaDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CExcelKonwersjaDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CExcelKonwersjaDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

void CExcelKonwersjaDlg::OnBnClickedButton1()
{
	CFileDialog fileDialog(TRUE, 0, 0, 2, 
        L"Arkusze Excel (*.xls)|*.xls|Wszystkie pliki (*.*)|*.*||");
            
    if(fileDialog.DoModal() != IDCANCEL)
		Edit1.SetWindowTextW(fileDialog.GetPathName());
    else
        MessageBox(L"Anulowano wybr pliku");
}

void CExcelKonwersjaDlg::OnBnClickedButton2()
{
	CFileDialog fileDialog(FALSE, 0, 0, 2, 
        L"Pliki .html (*.html, *.htm)|*.html;*.htm|Wszystkie pliki (*.*)|*.*||");
            
    if(fileDialog.DoModal() != IDCANCEL)
		Edit2.SetWindowTextW(fileDialog.GetPathName());
    else
        MessageBox(L"Anulowano wybr pliku");
}

void CExcelKonwersjaDlg::OnBnClickedButton3()
{
	CString plikZrodlowy, plikDocelowy;
	COleVariant cOpt(DISP_E_PARAMNOTFOUND, VT_ERROR);
	Edit1.GetWindowTextW(plikZrodlowy);
	Edit2.GetWindowTextW(plikDocelowy);

	if(!PathFileExists(plikZrodlowy))
		MessageBox(L"Nie odnaleziono pliku rdowego");
	else
	{
		COleException e;
		CApplication oExcel;
		CWorksheet oSheet;
		CWorkbook oBook;
		CWorkbooks oBooks;

		if(!oExcel.CreateDispatch(L"Excel.Application", &e))
		{
			e.ReportError();
			return;
		}
		oBooks = oExcel.get_Workbooks();
		oBook = oBooks.Open(plikZrodlowy, cOpt, cOpt, cOpt,
			cOpt, cOpt, cOpt, cOpt, cOpt, cOpt,
			cOpt, cOpt, cOpt);
		
		oSheet = oBook.get_ActiveSheet();
		oSheet.SaveAs(plikDocelowy, variant_t(MSExcel::xlHtml), //typ pliku
			cOpt, cOpt, cOpt, cOpt, 
			cOpt, variant_t(L"1252"), //strona kodowa
			cOpt);

		oBooks.Close();
		oExcel.ReleaseDispatch();

		CString temp;
		temp.Format(L"Pomylnie wyeksportowano plik %s do pliku %s", plikZrodlowy, plikDocelowy);
		MessageBox(temp);
	}
}
